<?php

namespace App\Models\Plan;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Plans extends Model 
{

    protected $table = 'plans';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('amount', 'case_limit', 'employee_limit', 'duration_id');

    public function duration()
    {
        return $this->hasMany('Duration');
    }

    public function subscription()
    {
        return $this->hasMany('Subscription');
    }

}